# -*- coding: utf-8 -*-
"""
Created on Wed Oct 07 11:58:29 2015

@author: gareth
"""
import matplotlib.pylab as plt
from CModel import CModel
import numpy as np

class CModels:

    def __init__(self):
        self.AdvectionOnly = CModel()
        self.ADELongitudinal = CModel()
        self.ADETransverse = CModel()
        self.ADZ = CModel()
        
        self.YMidIndex = 0
                
        # reference model is a pointer to an existing model
        # reference model is NOT a new model
        self.SetReferenceModel(self.ADETransverse) # default

    def PeakConcentrationsOverTimeResiduals(self,AModel):
        return AModel.PeakConcentrationsOverTime(self.YMidIndex) - self.ReferenceModel.PeakConcentrationsOverTime(self.YMidIndex)    

    def PeakNormalisedConcentrationsOverTimeResiduals(self,AModel):
        return AModel.PeakNormalisedConcentrationsOverTime(self.YMidIndex) - self.ReferenceModel.PeakNormalisedConcentrationsOverTime(self.YMidIndex)

    def PeakNormalisedConcentrationsOverTimeResidualsAverage(self,AModel):
        residuals_average = np.average(self.PeakNormalisedConcentrationsOverTimeResiduals(AModel))
        return residuals_average
        
    def PlotPeakResiduals(self, AModel, ATimeValues, ALabel, ALineStyle):
        residuals = self.PeakConcentrationsOverTimeResiduals(AModel)
        plt.plot(ATimeValues, residuals, label=ALabel, linestyle=ALineStyle)

    def PlotNormalisedPeakResiduals(self, AModel, ATimeValues, ALabel, ALineStyle):
        residuals = self.PeakNormalisedConcentrationsOverTimeResiduals(AModel)
        plt.plot(ATimeValues, residuals, label=ALabel, linestyle=ALineStyle)
       
    def SetReferenceModel(self,AReferenceModel):
        # this is where the user can define a different reference model
        self.ReferenceModel = AReferenceModel
